import pandas as pd  
import pickle
from decision_company import read_csv_file, access_dataframe_loc, access_dataframe_loc, logical_and, filter_by_condition, check_elements_in_list, fetch_column, f_oneway

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Filter customers with good credit history  
credit_history_column = fetch_column(credit_customers, 'credit_history')  
good_credit_history = check_elements_in_list(credit_history_column, ['existing paid', 'no credits/all paid', 'all paid'])  

print(good_credit_history)  
pickle.dump(good_credit_history,open("./ref_result/good_credit_history.pkl","wb"))